import pygame
pygame.display.set_mode([100,100])
import random
import math

from OpenGL.GL import *
from OpenGL.GLU import *

class bitmapfont:
  def __init__(self):
    self.base = glGenLists(96)
    pygame.font.init()
    self.font = pygame.font.SysFont("Courier New",24,0,0)
    self.characters = []
    self.tnames = glGenTextures(94)
    for i in range(32,32+94):
      char = self.font.render(chr(i),True,[255,255,255]).convert_alpha()
      char = pygame.transform.scale(char,[32,32])
      s = pygame.Surface([char.get_width(),char.get_height()])
      s.fill([0,0,0])
      s.blit(char,[0,0])
      #s = pygame.image.load("Data/Cube.bmp")
      if chr(i)=='a':
        pygame.image.save(s,"tst.tga")
      #self.characters.append(s)
      #glBindTexture(GL_TEXTURE_2D,self.tnames[i-32])
      #glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
      #glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
      #idat = pygame.image.tostring(s,"RGBA",True)
      #glTexImage2D(GL_TEXTURE_2D,0,4,s.get_width(),s.get_height(),0,GL_RGBA,GL_UNSIGNED_BYTE,idat)
      #make a display list for the character
      glNewList(self.base+i,GL_COMPILE)
      #glBindTexture(GL_TEXTURE_2D,self.tnames[i-32])
      px = .004
      px2 = px/3.
      py = .010
      py2 = py/3.
      hi = py*s.get_height()
      for y in range(s.get_height()):
        for x in range(s.get_width()):
          pixel = s.get_at([x,y])
          if [h for h in pixel[:3] if h]:
            glBegin(GL_QUADS)
            glVertex3f(px*x,hi-py*y+py2,0)
            glVertex3f(px*x+px2,hi-py*y+py2,0)
            glVertex3f(px*x+px2,hi-py*y,0)
            glVertex3f(px*x,hi-py*y,0)
            glEnd()
            #~ glTranslatef(-px,-py,-.1)
            #~ glBegin(GL_QUADS)
            #~ glVertex3f(px*x,hi-py*y+py,0)
            #~ glVertex3f(px*x+px,hi-py*y+py,0)
            #~ glVertex3f(px*x+px,hi-py*y,0)
            #~ glVertex3f(px*x,hi-py*y,0)
            #~ glEnd()
            #~ glTranslatef(px,py,.1)
      glTranslatef(px*s.get_width()*.75,0,0)
      glEndList()
  def write(self,text):
    glPushAttrib(GL_LIST_BIT)
    glListBase(self.base)
    #~ for c in text:
      #~ glCallList(ord(c)-31)
    glCallLists(text)
    glPopAttrib()

class Screen:
  def __init__(self):
    self.wi = 640
    self.hi = 480
    self.fullscreen = 0
    self.caption = "Nehe lesson 13 Bitmap Text"
    self.glinited = False
    self.texloaded = False
    self.tnames = []
    self.textures = []
    
    self.zval = -3
    
    #instance variables to be replaced with objects
    self.bfont = None
    self.c1 = 0
    self.c2 = 0
  def initGL(self):
    glEnable(GL_TEXTURE_2D)
    glShadeModel(GL_SMOOTH)
    glClearColor(0,0,0,0)
    glClearDepth(1.)
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST)
    #glEnable(GL_LIGHT0)
    #glEnable(GL_LIGHTING)
    glEnable(GL_COLOR_MATERIAL)
    
    #glEnable(GL_BLEND)
    #glBlendFunc(GL_SRC_ALPHA,GL_ONE)
    self.bfont = bitmapfont()
  def resize(self):
    wi,hi,fullscreen = self.wi,self.hi,self.fullscreen
    self.screen = pygame.display.set_mode([wi,hi],pygame.OPENGL|pygame.DOUBLEBUF|pygame.FULLSCREEN*fullscreen|pygame.RESIZABLE)
    pygame.display.set_caption(self.caption)
    if hi==0: hi = 1
    glViewport(0,0,wi,hi)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(45.,float(wi)/float(hi),.1,100.)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    if not self.glinited: self.initGL()
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glLoadIdentity()
    glTranslatef(0,0,self.zval)
    glColor3f(math.cos(self.c1),math.sin(self.c2),1-.5*math.cos(self.c1+self.c2))
    glTranslatef(.5*math.cos(self.c1),.35*math.sin(self.c2),0)
    #self.bfont.write("Active OpenGL Text With NeHe - %7.2f"%self.c1)
    self.bfont.write("I wonder how long a line I can write")
    self.c1 += .051
    self.c2 += .005

screen = Screen()
screen.resize()

piover180 = math.pi/180.0
running = 1
c = pygame.time.Clock()
while running:
  c.tick(60)
  screen.draw()
  pygame.display.flip()
  for e in pygame.event.get():
    if e.type==pygame.VIDEORESIZE:
      screen.wi,screen.hi = e.w,e.h
      screen.resize()
    if e.type==pygame.KEYDOWN:
      if e.key==pygame.K_ESCAPE:
        running = 0
      if e.key==pygame.K_RETURN:
        screen.wi,screen.hi,screen.fullscreen=40,40,0
        screen.resize()
  keys = pygame.key.get_pressed()
  if keys[pygame.K_PAGEUP]:
    pass
  if keys[pygame.K_PAGEDOWN]:
    pass
  if keys[pygame.K_RIGHT]:
    pass
  if keys[pygame.K_LEFT]:
    pass
  if keys[pygame.K_UP]:
    screen.zval += 1
  if keys[pygame.K_DOWN]:
    screen.zval -= 1
